#! /usr/bin/perl -w
#-----------------------------------------------------------------------------
#
#	FILE NAME
#
#		uninstall.pl
#
#	PURPOSE
#	
#		Kill all of the TouchPanelDriver process.
#		Also allows removing preferences for the 
#		current user or all users. 
#
#
#-----------------------------------------------------------------------------

use strict;
use Env;
use utf8;
use File::Basename;
use File::Path "rmtree";
use Getopt::Long;
use Data::Dumper;

# Make %ENV safer; this script runs as root
# removes search paths, so all commands must be issued with fully-qualified paths
$ENV{PATH} = "";
delete @ENV{qw(IFS CDPATH ENV BASH_ENV)};



##############################################################################
# Prototypes
sub killRunning;
sub deleteAllPreferenceFiles;
sub removeFileIfExists;


##############################################################################
# Globals

my $gDriverExecutable				= "SharpTouchPanel2Driver";
my $gDriverExecutableSetting		= "SharpTouchPanel2SettingUtility";


#------------------


#my $gOldPrefFile				= "SharpTouchDisplayDriver";
my $gOldPrefFile				= "SharpTouchPanel2";


#command line options & hash table
my $prefsOnly 					= 0;
my $currentPrefsOnly 		= "";
my $restartDrivers 			= 0;
my %commandOpts 				= ("prefsonly" => \$prefsOnly, "currentprefsonly=s" => \$currentPrefsOnly, "restartdrivers" => \$restartDrivers);
my @processList 				= `/bin/ps -axcopid,command`;
my @currentUserProcessList	= `/bin/ps -xcopid,command`;



##############################################################################
# main
##############################################################################
sub main
{

	#	print "start_____________****************____________________start\n";
		
		killRunning();
		deleteAllPreferenceFiles();

	#	print "finish_________||||||||||||||||||____________________finsh\n";
	
	exit 0;
}




##############################################################################
# killRunning
#
# Purpose:		kill all of driver process.
#
sub killRunning
{
	print "Start kill process\n";
	my @killPIDs;

	# Find PIDs of processes to kill
	foreach my $process (@processList)
	{
		# Driver
		if( $process =~ m/^\s*(\d+)\s+$gDriverExecutable$/ )
		{
			push @killPIDs, $1;
		}
		if( $process =~ m/^\s*(\d+)\s+$gDriverExecutableSetting$/ )
		{
			push @killPIDs, $1;
		}
	}

	# Kill 'em
	if ( scalar @killPIDs )
	{
		print "Killing SharpTouchPanel2Driver: @killPIDs\n";
		kill "QUIT", @killPIDs;
	}
	else
	{
		print "SharpTouchPanel2Driver not running.:\n";
	}
	
	print "Finish kill process\n";
			
}#end killRunning



##############################################################################
# deleteAllPreferenceFiles
#
# Purpose:	Deletes preferences files for all users.
#	

sub deleteAllPreferenceFiles
{
	print "Start Deleting Preferences:\n";
	
	my @homeList;
	my $homeRegEx;
	my $homeLine;
	my $prefFile;

	
	if(-e "/usr/bin/niutil")
	{
		# MacOS X Server
		@homeList = `/usr/bin/niutil -list . /users home`;
	}
	else
	{
		# MacOS X
		@homeList = `/usr/bin/dscl localhost -list /Search/Users home`;
	}

	$homeRegEx = '\s(/Users/.*)';
	
	#delete each user's preference file
	foreach $homeLine (@homeList)
	{
		next if not $homeLine =~ /$homeRegEx/;
		
		my $homePath		= $1;
		my $prefsFolder	= "$homePath/Library/Preferences";
		
		#delete legacy pref file
		$prefFile = "$prefsFolder/$gOldPrefFile";
		
		print "+++++perl $prefFile\n";
		removeFileIfExists($prefFile);
		
	}
	print "Finish Deleting Preferences:\n";
}



##############################################################################
sub removeFileIfExists
{
	my $full_path = shift;
	if(-e $full_path)
	{
		print "Removing in perl $full_path\n";
		rmtree([$full_path], 0, 0);
	}
}



##############################################################################
main();
